package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ItemLotteryresultBinding;
import app.firezone.synk.network.model.LotteryModel;


import java.util.ArrayList;

public class LotteryResultAdapter extends RecyclerView.Adapter<LotteryResultAdapter.holder> {


    Context mContext;
    ArrayList<LotteryModel> models = new ArrayList<LotteryModel>();



    public LotteryResultAdapter(Context mContext, ArrayList<LotteryModel> models) {
        this.mContext = mContext;
        this.models = models;
    }

    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.item_lotteryresult,parent,false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, int position) {

        LotteryModel list = models.get(position);

        holder.binding.dateTxt.setText(list.getDate());
        holder.binding.prizeWonTxt.setText(list.getPrize());
        holder.binding.playerWonTxt.setText(list.getWinnername());



        Picasso.get()
                        .load(list.getImages())
                                .placeholder(R.drawable.loading_img)
                                        .into(holder.binding.imageView26);



    }

    @Override
    public int getItemCount() {
        return models.size();
    }

    public class holder extends RecyclerView.ViewHolder {

        ItemLotteryresultBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);

            binding = ItemLotteryresultBinding.bind(itemView);

        }
    }
}
